# he longest common subsequence (LCS) problem is the problem of finding the longest subsequence common to all sequences in a set of sequences (often just two sequences).
# It differs from the longest common substring problem: unlike substrings, subsequences are not required to occupy consecutive positions within the original sequences. 
# solvable in time O(S*T) ※Computational complexity is the length of each string to compare


class DP:
    def __init__(self, S:str, T:str):
        self._S = S
        self._sLen = len(S)
        self._T = T
        self._tLen = len(T)
        self._dp = [[0 for _ in range(self._tLen+1)] for _ in range(self._sLen+1)]
    
    def lcs(self):
        for i in range(1, self._sLen+1):
            for j in range(1, self._tLen+1):
                if self._S[i-1] == self._T[j-1]:
                    self._dp[i][j] = self._dp[i-1][j-1]+1
                else:
                    self._dp[i][j] = max(self._dp[i-1][j], self._dp[i][j-1])
        return self.__restore()
    
    def __restore(self):
        RESTORE = ''
        i , j = self._sLen, self._tLen
        while(i>0 and j>0):
            if self._dp[i][j] == self._dp[i-1][j]:
                i -= 1
            elif self._dp[i][j] == self._dp[i][j-1]:
                j -= 1
            else:
                RESTORE = self._S[i-1]+RESTORE
                i -= 1
                j -= 1
        return RESTORE

S = 'axyb'
T = 'abyxb'

d = DP(S,T)
result = d.lcs()
print(result)  # axb


# lcs(DP table transition diagram)
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 0, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 0]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 0, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 0, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 2, 0]
# [0, 0, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 2, 2]
# [0, 0, 0, 0, 0, 0]
# --------------------
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 2, 2]
# [0, 1, 0, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 2, 2]
# [0, 1, 2, 0, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 2, 2]
# [0, 1, 2, 2, 0, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 2, 2]
# [0, 1, 2, 2, 2, 0]
# --------------------
# [0, 0, 0, 0, 0, 0]
# [0, 1, 1, 1, 1, 1]
# [0, 1, 1, 1, 2, 2]
# [0, 1, 1, 2, 2, 2]
# [0, 1, 2, 2, 2, 3]
# --------------------

# restore()
# b
# b
# xb
# xb
# xb
# axb